package gov.va.med.mhv.bluebutton.service.impl;

import gov.va.med.mhv.bluebutton.StudyBusinessService;
import gov.va.med.mhv.bluebutton.converter.StudyJobListConverter;
import gov.va.med.mhv.bluebutton.converter.StudyListConverter;
import gov.va.med.mhv.bluebutton.repository.StudyJobRepository;
import gov.va.med.mhv.bluebutton.repository.StudyRepository;
import gov.va.med.mhv.bluebutton.transfer.StudyDTO;
import gov.va.med.mhv.bluebutton.transfer.StudyJobDTO;
import gov.va.med.mhv.common.api.exception.MHVException;

import java.util.List;

import javax.annotation.Resource;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * Service implementation class for the StudyBusiness service
 * @see gov.va.med.mhv.bluebutton.StudyBusinessService
 */

@Component
public class StudyBusinessServiceImpl implements StudyBusinessService {
	
	@Resource
	private StudyRepository repository;
	
	@Resource
	private StudyJobRepository jobRepository;
	
	@Autowired
	StudyListConverter studyListConverter;
	
	public List<StudyDTO> getStudies(Long patientId) throws MHVException {
		return studyListConverter.convert(repository.findByPatientId(patientId));
	}
	
}
